#ifndef __CONSOLE_H__
#define __CONSOLE_H__

////////////////////////////////////////////////////////////////////////////////

#include "nutypedefs.h"
#include "dm_console.h"

////////////////////////////////////////////////////////////////////////////////
#ifdef __cplusplus
extern "C" {
#endif

#define ASC_BKSP                        0x08
#define EOL_CHAR                        0x0D        // use CR for line terminator
#define INHIBIT_PROMPT                  (-3)       // needed so that viewport does not see an
                                                //    early prompt upon reboot

#define ANY_EXE                         0x0000            // used for caller_banned field of COMMAND_TABLE
#define TELNET_EXE                      0x0001
#define CTP_EXE                         0x0002
#define SERIAL_EXE                      0x0004
#define DEBUG_EXE                       0x0008
#define REDIRECT_EXE                    0x0010
#define USB_EXE                         0x0020
#define TJI_EXE                         0x0040
#define RCON_EXE                        0x0080
#define PASSTO_EXE						0x0100
#define PC_EXE                          0x0200
#define APPSERIAL_EXE                   0x0400
#define SRC_BANNED_MASK                 0xFFFF

#define NO_HELP_MENU                    0x0000
#define MAIN_HELP                       0x0001
#define DEVICE_HELP                     0x0002
#define ETHERNET_HELP                   0x0004
#define FILE_HELP                       0x0008
#define SYSTEM_HELP                     0x0010
#define AUDIO_HELP                      0x0020
#define VIDEO_HELP                      0x0040
//                                      0x0080
#define DEBUG_HELP                      0x0100

#define ALL_CMDS_HELP                   0x00ff        // used to display all commands
#define SYSTEM_TEST_HELP                0xffff

// only need this if we want to be able to ban
// commands according to their source  must correspond to _EXE above
#define FROM_TELNET_CLIENT       0x0001
#define FROM_CTP_CLIENT          0x0002
#define FROM_SETUP_SCREEN        0x0004
#define FROM_UART_CONSOLE        0x0008
#define FROM_CNET_REDIRECT       0x0010
#define FROM_USB_CONSOLE         0x0020
#define FROM_TJI_REDIRECT        0x0040
#define FROM_RCON_REDIRECT       0x0080
#define FROM_PASSTO_REDIRECT     0x0100
#define FROM_PC_CONSOLE          0x0200

// Constant to indicate that there is no UART
#define NO_CONSOLE_UART_PRESENT         0xFF

//Fo - Convert existing console timeout to macros that prevent confusion
#define DM_CONSOLE_WAIT_POLL_RATE_MS    5
#define MAX_CONSOLE_WAIT                (25000/DM_CONSOLE_WAIT_POLL_RATE_MS)  // timeout for processing RCON command (25 second)

#define CONSOLE_QUEUE_TIMEOUT 3000 // 30 seconds
#define MAX_CONSOLE_TJI_PRINT_WAIT 25000
#define MAX_CONSOLE_TJI_PRINT_WAIT_PERIOD 1
#define MAX_CONSOLE_PRINT_WAIT 250 //250 ms  apprx time to send 2x255 packets at 115200 baud

typedef void (*PF_DM_PREPARE_REBOOT)( void );
extern PF_DM_PREPARE_REBOOT pfDmPrepareReboot;

#ifdef __cplusplus
}
#endif
#endif


